# 程序员快速成长的六大方法

> 工作中如何快速成长，突破职业瓶颈



你好，我是程序员鱼皮。

转眼又是一年，很多小伙伴刚刚步入职场，难免会对未来的成长感到焦虑困惑。

今天我想和大家聊一个很现实的问题：如果你去了一个外包公司，或者你的工作本身不能带给你成长，应该如何破局？

跑，快跑！

![](https://pic.yupi.icu/1/image-20250815104851768.png)

开个玩笑，既然工作不能带给你成长，那就自己学习呗，纯把工作当做是金钱和劳动的交易就好。

这个问题其实很大，考虑到大家可能不太喜欢听那些空洞的理论，所以我就直接分享我自己的做法，以及我观察到的一些成长很快的大佬都是怎么做的。

> 其实这个问题我在直播时聊过，可以看视频版：https://bilibili.com/video/BV1DC4y177sB



## 一、每天读几篇文章

嗯，每天就读 2 ~ 3 篇文章，不用多，能养成习惯就好。

但是你要有选择地读，不要什么都读。

读什么文章呢？首先是 **行业趋势类** 的文章，让你始终跟紧这个行业，能跟同事和面试官聊新的东西。比如说 AI 火了，首先要去了解一下 AI 会不会对自己有影响，如果会，那就去学习一下 AI 相关的工具。

其次是 **技术类的文章**，但一定要结合自己工作相关的方向。假设你每天读 2 ~ 3 篇文章，一年是多少？一年那就是将近 1000 篇！你换算成教程，那可能就是几十个教程。这对你的成长绝对是巨大的，而且这是一个非常轻松的工作。

我自己也是坚持这么做的。哪怕说我现在开公司了，我反而会读更多的文章，因为我现在不仅要了解行业趋势、了解技术，我还要了解产品、了解项目管理，甚至要了解怎么招人。

有同学问看哪里的文章？最推荐的是 **大厂的技术博客**。我关注了一大堆的技术团队，当然这些分享的内容可能会比较硬核。还有科技资讯类、经验分享、编程趋势、技术干货，我自己的号基本上什么都分享。

像今年我们还打造了完全免费的 AI 交流圈，大家可以没事儿来刷一刷：https://ai.codefather.cn

![](https://pic.yupi.icu/1/image-20260109121412266-20260113154640560.png)



## 二、持续学习新技术

如果你能做到上面这点，恭喜你，可以进阶提升一下每日学习的时长，因为有些知识是不建议碎片化学习的。

你可以尝试每天抽不到一个小时，看 2 ~ 3 集教程，只要坚持一个月，你就能看完一套课。如果在你工作期间，一年内你有 6 个月能做到这点，那么你不会被淘汰。

这里有一个重要的点：**裁员不等于淘汰**。你被裁了，不一定是你的问题，因为有可能是这家公司经营不善或者公司不干人事，这是最坏的情况，不要因为一些不可抗力影响了自己的信心。



## 三、复盘总结

这个是我到现在一直都在做的事情，而且这个复盘总结很简单：

第一步：每天记录自己完成的工作。

你今天修了个 bug，记下来，一分钟都不到；你做完了一个需求，记下来，贴个文档，就这么简单。像我当时一般是每天下班前会记录。

第二步：每月记录自己这个月重点在做的事，以及完成的工作、学习的情况等。

我当时刚开始实习的时候，每天都在记。我不仅记工作内容，还在记感悟、收获。比如跟导师交流之后，有很多的想法，我都会记。

第三步：每半年，或者说每完成一个大事，做一个复盘总结。

这个复盘总结就相对要完整一点，就是记录自己做这件事情的经历、过程、结果，以及好和不好的地方。你把这个点记录完成之后，你在做下一段事情的时候，重复的坑就不会踩了。而且很多公司本来就要求半年或一年搞一次绩效评估，如果你之前就已经有记录总结，写这玩意的时候那不是直接复制粘贴？



## 四、整理自己的弹药库

大家觉得工作 3 年的人和工作 1 年的人相比，最大的差别或者多出来的东西是什么？

那就是经验啊！

你不能说工作 3 年的人，你积累的内容和工作 1 年的人是一样的，哪怕剩下 2 年天天 CRUD，也得成为 CRUD 大师了。

那为什么有些人工作 3 年还和 1 年一样呢？

因为他可能的确工作了 3 年，但是到第 3 年的时候，第 1 年自己做过的事情就忘完了。他做过的系统设计方案、他接触过的技术，全都忘了。

实际上你别说 3 年，我都不记得自己 1 个月前写了什么代码。

![忘记代码](https://pic.yupi.icu/1/image-20250815104740029.png)

**经验积累是决定你后续的路能走多远、走多稳的一个重要因素**。

怎么积累呢？



### 1、整理属于自己的 bug 库

也就是你解决过的问题，这很有可能成为你跟面试官交流的素材。



### 2、整理属于自己的经验库

就是你工作中的技巧和踩过的坑，不一定局限于编程方面，也可以是职场经验。比如我当时自己感悟出来的：

- 你不要把自己全部交给公司
- 你不要把所有的底牌暴露出来
- 你不要让你的老板觉得你只有这些东西了
- 可以和同事交朋友，但是要注意保持边界

虽然有的经验不一定对，但这也是自己沉淀的东西。



### 3、整理自己学过的知识点

把你学过的所有知识点，以碎片的形式进行记录整理。

什么叫碎片呢？

我就以编程导航给大家拆解的项目知识碎片为例。所谓的知识碎片，就是那种你可以把它拆解出来，去运用到任何项目上的一个很小很小的知识点。

比如说 Ant Design Pro 框架怎么用，就是一个知识碎片；怎么初始化 Java 项目，就是一个很简单的知识碎片。

为什么我建议大家整理碎片呢？

首先，整理碎片很简单，你就写清楚一个很小很小的知识点，哪怕只有 5 分钟，把它写出来。这样你没有那种 "我要写一篇长篇大论" 的负担，有利于你养成习惯。

像鱼皮自己有个有趣的习惯，我会 "口遁"，有时候想记录了，直接掏出手机叭叭一通乱说，利用语音转文字快速记录。实不相瞒，有些文章都是我口遁出来的，看过我直播的同学应该也知道，给我个话题，我叭叭能给你说一大堆有的没的。

![口遁](https://pic.yupi.icu/1/image-20250815104416663.png)

其次，为什么要拆成碎片？是因为每个碎片它都是可复用的。你之后想做一个自己的项目了，你就打开整理的知识碎片列表看一看。比如说这个项目，能不能给它加一个全局权限管理？能不能加个缓存？如果发现能加，那就点进具体的知识碎片，看看我之前是怎么做的就好了。



### 4、积累自己的工具库

你用什么记录笔记？你用什么去写文档？用什么做思维导图？

这些都是你可以整理的。

比如我自己经常上网学东西，不经意间就发现了一个新的宝藏工具，如果我不积累，可能真到需要使用这个工具时，就想不起来了。

最理想的情况下，当你换了一台电脑的时候，你能够很快地把你常用的工具在你的新电脑上完成安装，这就发挥了工具库的意义。



## 五、分享

这个真的是我自己的真实经历，你们都能看得到。

**注意，分享不等于做自媒体！** 自媒体可能是分享后面的阶段。当你分享的内容多了之后，再去做自媒体，那叫水到渠成，而不用刻意。

要怎么做呢？

还记得我前面提到的几个建议么，现在是不是已经有一堆自己的干货了？比如：

1. 分享自己的复盘总结和经历
2. 分享自己的弹药库
3. 分享自己学过的知识点
4. 帮助别人答疑解惑

这 4 点你只要做到，并且坚持做之后，你哪怕是没有专门想去做自媒体，你一定会收获一些粉丝，一定会得到一些关注。

记得我刚开始做自媒体时，分享的全部是面试题。为什么呢？因为我那段时间就是在找工作，我那段时间自己就天天看这些东西，我顺便把它分享出来，仅此而已。不需要给我增加什么额外的负担，为了帮助自己加深印象，我才去分享。

你会发现，我前面提的几个成长之法，全部都是按照顺序来的，是很自然的、在工作中可以做的，并且给你带来成长的事情。先学技术，持续积累，然后复盘总结，复盘总结过程中持续整理，整理之后把它分享出来。



## 六、学会目标拆解

在做以上的事情的过程中，你要持续地践行一个操作，就是 **将目标拆解**。

当你意识到想要做一件很大的事情很难的时候，你要学会把这个目标进行拆解。把一件大事拆分成一些更确定的、更简单的，甚至是你利用碎片化时间都能学习的小事。

比如说你要过英语四级，可以把它拆解为每天背 10 个单词，每周背 50 个单词并且复习，每月背 200 个单词并且复习。

大家有的时候之所以不去做，是不是因为觉得太难了？我会担心自己做不下来、我会觉得自己工作忙，可能今天想做，明天工作一忙，我又把它搁置了。**因为有很多的不确定性，所以导致我们最后什么事情都做不了。**

所以说大家一定要学会工作的拆解、目标的拆解，把它拆分成一条路线，一个很清晰的文档。哪怕你中间隔了 7 天，只要捡起来，就能按照文档往下一步一步地继续走，那就能够完成。

如果你觉得一件事情非常难，那么就从简单的事情开始做起。如果你觉得一个小计划还难，那就再拆。如果你觉得看一节课都难，那就再拆，拆分成每天看 10 分钟，4 天看完一节 40 分钟的课。这样做最起码能保证你有一定的收获，不至于任何事情都开启不了。

**种一棵树最好的时间是 10 年前，其次是现在。**

什么时候开始都不晚，因为还有很多同学比你更晚。就从明天开始坚持 7 天，然后试着坚持 21 天，你绝对能意识到自己的进步。



---



以上就是关于程序员工作后怎么提升自己的分享，当然我相信不仅局限于程序员，任何工作都是适用的，希望对大家有帮助！




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
